/*
 * Decompiled with CFR 0.152.
 */
package gt2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import one.Match;
import one.Sequence;

public class Main
extends JFrame {
    private UIManager.LookAndFeelInfo[] looks = UIManager.getInstalledLookAndFeels();
    private JLabel lbl1;
    private JLabel lbl2;
    private JLabel lbl3;
    private JLabel lbl4;
    private JLabel lbl5;
    private JLabel lbl6;
    private JLabel lbl6a;
    private JLabel lbl7;
    private JLabel lbl8;
    private JLabel lbl9;
    private JTextField DNA1Fld;
    private JTextField DNA2Fld;
    private JTextField matchFld;
    private JTextField misFld;
    private JTextField gapFld;
    private JTextField initFld;
    private JTextField finalFld;
    private JButton createMatchButton;
    private JButton colorMatchButton;
    private JButton createLocalButton;
    private JButton colorLocalButton;
    private JFrame drawFrame;
    private static Sequence seq1;
    private static Sequence seq2;
    private static Match match1;
    private boolean[][] isColored;

    public Main() {
        super("Global Alignment - Input");
        try {
            UIManager.setLookAndFeel(this.looks[2].getClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem howToItem = new JMenuItem("How to...");
        howToItem.setMnemonic('H');
        helpMenu.add(howToItem);
        howToItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JOptionPane.showMessageDialog(Main.this, "To use this program you can type or paste a sequence\ninto the DNA Sequence boxes, after setting the values\nfor match, mismatch, gap and initial gap, press the\n\"Global Match\" or \"Local Match\" button.  The match \nmatrix will appear in the panel on the right.  After a Global\nMatch has been created, one of the optimal alignments will\nappear in the panel above the bottons as well as the number\nof alignments that share the same match value with that\nalignment.  To see the alignments in the matrix, click\nthe \"Color Global\" or \"Color Local\" button and the\noptimal alignment's paths will be colored on the matrix.\n\nYou can then change any of the setup values, and click\nthe Create Match button to check additional strings or\nvalues for alignment.\n\nTo create a semi-global alignment, change the initial\n and final gap values to '0' and use the \"Global Match\" button.\n\nInitial and final gap values are ignored (and treated\nthe same as the gap value) in local alignments.\n\nCase is ignored in all of the alignments.");
            }
        });
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.setMnemonic('A');
        helpMenu.add(aboutItem);
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JOptionPane.showMessageDialog(Main.this, "This program was created by James Kupetz\nas part of the Biomath Connect Institute at DIMACS.\nIt may be freely used for educational purposes.\nIf you find it useful, or would like to suggest changes,\nI would appreciate if you would drop me a note at\nsckupetzj@hotmail.com or even better let the\npeople who fund this project know that you use\nit and that they should continue to fund projects\nlike this.  They are The Center for Discrete Mathematics\nand Theoretical Computer Science (DIMACS),\nthe National Science Foundation (NSF), Rutgers\nUniversity and the Colorado Institute of Technology");
            }
        });
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setMnemonic('X');
        fileMenu.add(exitItem);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        JMenuBar bar = new JMenuBar();
        this.setJMenuBar(bar);
        bar.add(fileMenu);
        bar.add(helpMenu);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(0, 1));
        super.setFont(new Font("Monospaced", 0, 12));
        this.lbl1 = new JLabel("DNA string 1:");
        container.add(this.lbl1);
        this.DNA1Fld = new JTextField("ACCATGG");
        container.add(this.DNA1Fld);
        this.lbl2 = new JLabel("DNA string 2:");
        container.add(this.lbl2);
        this.DNA2Fld = new JTextField("ACTGGCA");
        container.add(this.DNA2Fld);
        this.lbl3 = new JLabel("match");
        container.add(this.lbl3);
        this.matchFld = new JTextField("1");
        container.add(this.matchFld);
        this.lbl4 = new JLabel("mismatch");
        container.add(this.lbl4);
        this.misFld = new JTextField("-1");
        container.add(this.misFld);
        this.lbl5 = new JLabel("gap");
        container.add(this.lbl5);
        this.gapFld = new JTextField("-2");
        container.add(this.gapFld);
        this.lbl6 = new JLabel("initial gap");
        container.add(this.lbl6);
        this.initFld = new JTextField("-2");
        container.add(this.initFld);
        this.lbl6a = new JLabel("final gap");
        container.add(this.lbl6a);
        this.finalFld = new JTextField("-2");
        container.add(this.finalFld);
        this.lbl7 = new JLabel("The matched strings (with gaps)");
        container.add(this.lbl7);
        this.lbl8 = new JLabel("will appear here.");
        container.add(this.lbl8);
        this.lbl9 = new JLabel("The number of matches is put here.");
        container.add(this.lbl9);
        ButtonHandler handler = new ButtonHandler();
        this.createMatchButton = new JButton("Global Match");
        container.add(this.createMatchButton);
        this.createMatchButton.addActionListener(handler);
        this.createMatchButton.setActionCommand("createMatch");
        this.colorMatchButton = new JButton("Color Global");
        container.add(this.colorMatchButton);
        this.colorMatchButton.addActionListener(handler);
        this.colorMatchButton.setActionCommand("colorMatch");
        this.colorMatchButton.setEnabled(false);
        this.createLocalButton = new JButton("Local Match");
        container.add(this.createLocalButton);
        this.createLocalButton.addActionListener(handler);
        this.createLocalButton.setActionCommand("createLocal");
        this.colorLocalButton = new JButton("Color Local");
        container.add(this.colorLocalButton);
        this.colorLocalButton.addActionListener(handler);
        this.colorLocalButton.setActionCommand("colorLocal");
        this.colorLocalButton.setEnabled(false);
        this.setSize(275, 450);
        this.setVisible(true);
        this.drawFrame = new JFrame("Matrix");
        this.drawFrame.setBounds(276, 0, 700, 700);
        this.drawFrame.setVisible(true);
        this.drawFrame.getContentPane().setBackground(new Color(239, 239, 239));
    }

    public void colorLocal() {
        int j;
        int i;
        this.colorLocalButton.setEnabled(false);
        int width = this.drawFrame.getWidth() - this.drawFrame.getInsets().left - this.drawFrame.getInsets().right;
        int height = this.drawFrame.getHeight() - this.drawFrame.getInsets().top - this.drawFrame.getInsets().bottom;
        int cellWidth = width / (seq1.getLength() + 2);
        int cellHeight = height / (seq2.getLength() + 2);
        int leftEdge = this.drawFrame.getInsets().left;
        int topEdge = this.drawFrame.getInsets().top;
        this.isColored = new boolean[seq2.getLength() + 1][seq1.getLength() + 1];
        for (int i2 = 0; i2 <= seq2.getLength(); ++i2) {
            for (int j2 = 0; j2 <= seq1.getLength(); ++j2) {
                this.isColored[i2][j2] = false;
            }
        }
        int largest = 0;
        for (i = 1; i <= seq2.getLength(); ++i) {
            for (j = 1; j <= seq1.getLength(); ++j) {
                if (match1.getValMatrix(i, j) <= largest) continue;
                largest = match1.getValMatrix(i, j);
            }
        }
        for (i = 1; i <= seq2.getLength(); ++i) {
            for (j = 1; j <= seq1.getLength(); ++j) {
                if (match1.getValMatrix(i, j) != largest) continue;
                this.colorSquare(i, j, cellWidth, cellHeight, leftEdge, topEdge);
            }
        }
    }

    public void colorMatch(Sequence seq1, Sequence seq2, Match match1) {
        this.colorMatchButton.setEnabled(false);
        int width = this.drawFrame.getWidth() - this.drawFrame.getInsets().left - this.drawFrame.getInsets().right;
        int height = this.drawFrame.getHeight() - this.drawFrame.getInsets().top - this.drawFrame.getInsets().bottom;
        int cellWidth = width / (seq1.getLength() + 2);
        int cellHeight = height / (seq2.getLength() + 2);
        int leftEdge = this.drawFrame.getInsets().left;
        int topEdge = this.drawFrame.getInsets().top;
        this.isColored = new boolean[seq2.getLength() + 1][seq1.getLength() + 1];
        for (int i = 0; i <= seq2.getLength(); ++i) {
            for (int j = 0; j <= seq1.getLength(); ++j) {
                this.isColored[i][j] = false;
            }
        }
        this.colorSquare(seq2.getLength(), seq1.getLength(), cellWidth, cellHeight, leftEdge, topEdge);
    }

    public void colorSquare(int i, int j, int cellWidth, int cellHeight, int leftEdge, int topEdge) {
        int uLx = leftEdge + (j + 1) * cellWidth;
        int uLy = topEdge + (i + 1) * cellHeight;
        Graphics2D gr2d = (Graphics2D)this.drawFrame.getGraphics();
        gr2d.setColor(Color.RED);
        gr2d.setStroke(new BasicStroke(5.0f));
        this.isColored[i][j] = true;
        switch (match1.getDirMatrix(i, j)) {
            case 'c': {
                gr2d.drawLine((int)((double)uLx + 0.7 * (double)cellWidth), uLy, (int)((double)uLx + 0.7 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                gr2d.drawLine(uLx, (int)((double)uLy + 0.7 * (double)cellHeight), (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.7 * (double)cellHeight));
                gr2d.drawLine(uLx, uLy, (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                if (!this.isColored[i - 1][j]) {
                    this.colorSquare(i - 1, j, cellWidth, cellHeight, leftEdge, topEdge);
                }
                if (!this.isColored[i][j - 1]) {
                    this.colorSquare(i, j - 1, cellWidth, cellHeight, leftEdge, topEdge);
                }
                if (this.isColored[i - 1][j - 1]) break;
                this.colorSquare(i - 1, j - 1, cellWidth, cellHeight, leftEdge, topEdge);
                break;
            }
            case 'b': {
                gr2d.drawLine((int)((double)uLx + 0.7 * (double)cellWidth), uLy, (int)((double)uLx + 0.7 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                gr2d.drawLine(uLx, (int)((double)uLy + 0.7 * (double)cellHeight), (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.7 * (double)cellHeight));
                if (!this.isColored[i - 1][j]) {
                    this.colorSquare(i - 1, j, cellWidth, cellHeight, leftEdge, topEdge);
                }
                if (this.isColored[i][j - 1]) break;
                this.colorSquare(i, j - 1, cellWidth, cellHeight, leftEdge, topEdge);
                break;
            }
            case 'e': {
                gr2d.drawLine((int)((double)uLx + 0.7 * (double)cellWidth), uLy, (int)((double)uLx + 0.7 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                gr2d.drawLine(uLx, uLy, (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                if (!this.isColored[i - 1][j]) {
                    this.colorSquare(i - 1, j, cellWidth, cellHeight, leftEdge, topEdge);
                }
                if (this.isColored[i - 1][j - 1]) break;
                this.colorSquare(i - 1, j - 1, cellWidth, cellHeight, leftEdge, topEdge);
                break;
            }
            case 'f': {
                gr2d.drawLine(uLx, uLy, (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                gr2d.drawLine(uLx, (int)((double)uLy + 0.7 * (double)cellHeight), (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.7 * (double)cellHeight));
                if (!this.isColored[i][j - 1]) {
                    this.colorSquare(i, j - 1, cellWidth, cellHeight, leftEdge, topEdge);
                }
                if (this.isColored[i - 1][j - 1]) break;
                this.colorSquare(i - 1, j - 1, cellWidth, cellHeight, leftEdge, topEdge);
                break;
            }
            case 'h': {
                gr2d.drawLine(uLx, (int)((double)uLy + 0.7 * (double)cellHeight), (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.7 * (double)cellHeight));
                if (this.isColored[i][j - 1]) break;
                this.colorSquare(i, j - 1, cellWidth, cellHeight, leftEdge, topEdge);
                break;
            }
            case 'v': {
                gr2d.drawLine((int)((double)uLx + 0.7 * (double)cellWidth), uLy, (int)((double)uLx + 0.7 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                if (this.isColored[i - 1][j]) break;
                this.colorSquare(i - 1, j, cellWidth, cellHeight, leftEdge, topEdge);
                break;
            }
            case 'd': {
                gr2d.drawLine(uLx, uLy, (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                if (this.isColored[i - 1][j - 1]) break;
                this.colorSquare(i - 1, j - 1, cellWidth, cellHeight, leftEdge, topEdge);
                break;
            }
            case 'n': {
                break;
            }
        }
    }

    public void paint(Graphics gr) {
        super.paint(gr);
    }

    public void drawMatch(Sequence seq1, Sequence seq2, Match match1, String whichType) {
        int i;
        Graphics2D gr2d = (Graphics2D)this.drawFrame.getGraphics();
        this.drawFrame.paint(gr2d);
        int width = this.drawFrame.getWidth() - this.drawFrame.getInsets().left - this.drawFrame.getInsets().right;
        int height = this.drawFrame.getHeight() - this.drawFrame.getInsets().top - this.drawFrame.getInsets().bottom;
        int cellWidth = width / (seq1.getLength() + 2);
        int cellHeight = height / (seq2.getLength() + 2);
        int leftEdge = this.drawFrame.getInsets().left;
        int topEdge = this.drawFrame.getInsets().top;
        int pointSize = whichType == "createMatch" ? (cellHeight < cellWidth ? (int)((double)cellHeight / 2.5) : (int)((double)cellWidth / 2.5)) : (cellHeight < cellWidth ? cellHeight / 2 : cellWidth / 2);
        gr2d.setFont(new Font("Sans Serif", 0, pointSize));
        gr2d.setPaint(Color.BLACK);
        for (i = 2; i < seq1.getLength() + 2; ++i) {
            gr2d.drawRect((int)((double)(leftEdge + i * cellWidth) + (double)cellWidth * 0.4), (int)((double)topEdge + (double)cellHeight * 0.4), (int)((double)cellWidth * 0.6), (int)((double)cellHeight * 0.6));
            gr2d.drawString("" + seq1.getBase(i - 2), (int)((double)(leftEdge + i * cellWidth) + (double)cellWidth * 0.5), (int)((double)topEdge + (double)cellHeight * 0.9));
        }
        for (int j = 2; j < seq2.getLength() + 2; ++j) {
            gr2d.drawRect((int)((double)leftEdge + (double)cellWidth * 0.4), (int)((double)(topEdge + j * cellHeight) + (double)cellHeight * 0.4), (int)((double)cellWidth * 0.6), (int)((double)cellHeight * 0.6));
            gr2d.drawString("" + seq2.getBase(j - 2), (int)((double)leftEdge + (double)cellWidth * 0.5), (int)((double)(topEdge + j * cellHeight) + (double)cellHeight * 0.9));
        }
        topEdge += cellHeight;
        leftEdge += cellWidth;
        gr2d.setColor(Color.BLUE);
        for (i = 0; i < seq2.getLength() + 1; ++i) {
            block12: for (int j = 0; j < seq1.getLength() + 1; ++j) {
                int uLx = leftEdge + j * cellWidth;
                int uLy = topEdge + i * cellHeight;
                gr2d.drawRect((int)((double)uLx + (double)cellWidth * 0.4), (int)((double)uLy + (double)cellHeight * 0.4), (int)((double)cellWidth * 0.6), (int)((double)cellHeight * 0.6));
                gr2d.drawString("" + match1.getValMatrix(i, j), (int)((double)uLx + (double)cellWidth * 0.45), (int)((double)uLy + (double)cellHeight * 0.9));
                switch (match1.getDirMatrix(i, j)) {
                    case 'c': {
                        gr2d.drawLine(uLx, (int)((double)uLy + 0.7 * (double)cellHeight), (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.7 * (double)cellHeight));
                    }
                    case 'e': {
                        gr2d.drawLine((int)((double)uLx + 0.7 * (double)cellWidth), uLy, (int)((double)uLx + 0.7 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                    }
                    case 'd': {
                        gr2d.drawLine(uLx, uLy, (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                        continue block12;
                    }
                    case 'f': {
                        gr2d.drawLine(uLx, uLy, (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                    }
                    case 'h': {
                        gr2d.drawLine(uLx, (int)((double)uLy + 0.7 * (double)cellHeight), (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.7 * (double)cellHeight));
                        continue block12;
                    }
                    case 'b': {
                        gr2d.drawLine(uLx, (int)((double)uLy + 0.7 * (double)cellHeight), (int)((double)uLx + 0.4 * (double)cellWidth), (int)((double)uLy + 0.7 * (double)cellHeight));
                    }
                    case 'v': {
                        gr2d.drawLine((int)((double)uLx + 0.7 * (double)cellWidth), uLy, (int)((double)uLx + 0.7 * (double)cellWidth), (int)((double)uLy + 0.4 * (double)cellHeight));
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        Main application = new Main();
        application.setDefaultCloseOperation(3);
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            String whatHappened = event.getActionCommand();
            if (whatHappened.equals("createMatch")) {
                Main.this.colorMatchButton.setEnabled(true);
                seq1 = new Sequence(Main.this.DNA1Fld.getText().toUpperCase());
                seq2 = new Sequence(Main.this.DNA2Fld.getText().toUpperCase());
                match1 = new Match();
                match1 = seq1.simpleMatch(seq2, Integer.valueOf(Main.this.matchFld.getText()), Integer.valueOf(Main.this.misFld.getText()), Integer.valueOf(Main.this.gapFld.getText()), Integer.valueOf(Main.this.initFld.getText()), Integer.valueOf(Main.this.finalFld.getText()));
                Main.this.lbl7.setText(match1.getFirstSeq());
                Main.this.lbl8.setText(match1.getSecondSeq());
                if (match1.getMatchNum() == 1) {
                    Main.this.lbl9.setText("There is " + match1.getMatchNum() + " optimal match.");
                } else {
                    Main.this.lbl9.setText("There are " + match1.getMatchNum() + " optimal matches.");
                }
                Main.this.drawMatch(seq1, seq2, match1, whatHappened);
            } else if (whatHappened.equals("colorMatch")) {
                Main.this.colorMatch(seq1, seq2, match1);
            } else if (whatHappened.equals("createLocal")) {
                Main.this.colorLocalButton.setEnabled(true);
                seq1 = new Sequence(Main.this.DNA1Fld.getText().toUpperCase());
                seq2 = new Sequence(Main.this.DNA2Fld.getText().toUpperCase());
                match1 = new Match();
                match1 = seq1.localMatch(seq2, Integer.valueOf(Main.this.matchFld.getText()), Integer.valueOf(Main.this.misFld.getText()), Integer.valueOf(Main.this.gapFld.getText()));
                Main.this.lbl7.setText("");
                Main.this.lbl8.setText("");
                Main.this.lbl9.setText("");
                Main.this.drawMatch(seq1, seq2, match1, whatHappened);
            } else if (whatHappened.equals("colorLocal")) {
                Main.this.colorLocal();
            }
        }
    }
}

