#ifndef __GENRAND_H
#define __GENRAND_H

#define MAXRAND (1 << 30)

/* HMAXRAND should divide MAXRAND, with HMAXRAND^2 < 1<<31 and
   (MAXRAND/HMAXRAND)^2 < 1<<31 */

#define HMAXRAND (1<<15)

/* sprand initializes the random number generator, using seed as an
   initial seed. */

void sprand (int seed);

/* lprand returns a random number uniform from 0 to MAXRAND-1 */

int lprand (void);

/* rangerand returns a random number uniform from 0 to range-1 */

int rangerand (int range);

#endif /* __GENRAND_H */
