#include <stdlib.h>
#include <stdio.h>

#define MAXMAT 3200
#define INF 1

int distmat[MAXMAT][MAXMAT];
int outmat[3*MAXMAT][3*MAXMAT];

main (argc, argv)
int argc;
char **argv;

{
  FILE *fp, *fopen();
  int size;
  int max = 0;
  int inf = INF;
  int dist;
  int I;
  int i,j;
  char c;

  if (argc < 2) {
	printf("Usage:  symmetrize matrix tourlength-upperbound\n");
	exit(0);
  }

  fp = fopen(argv[1], "r");
  if (fp == NULL) {
	printf("Error opening input file\n");
	exit(0);
  }
  if (argc > 2) inf = atoi(argv[2]);

	fscanf(fp,"%d %c",&size,&c);

	if (c!='A') {
	  printf("ReadR: file %s is not random distance matrix\n",argv[1]);
	  exit(0);
	}

	if (size > MAXMAT) {
	  printf ("Too many cities.\n");
	  exit(0);
	}

	if (c == 'A') {

	  for (i=1;i<=size;i++)
	    for (j=1;j<=size;j++) {
		fscanf(fp,"%d",&dist);
		if (dist > max) max = dist;
	  	distmat[i][j] = dist;
	    }
	}

	for (i=1;i<=size;i++)
		for (j=1;j<=size;j++) {
			I = 3*i-2;
			if (i==j) {
				outmat[3*i-2][3*i-2] = 0;
				outmat[3*i-2][3*i-1] = 0;
				outmat[3*i-2][3*i] = inf;
				outmat[3*i-1][3*i-1] = 0;
				outmat[3*i-1][3*i] = 0;
				outmat[3*i][3*i] = 0;
			}
			else {
				outmat[I][3*j-2] = inf;
				outmat[I][3*j-1] = inf;
				outmat[I++][3*j] = distmat[i][j];
				outmat[I][3*j-2] = inf;
				outmat[I][3*j-1] = inf;
				outmat[I++][3*j] = inf;
				outmat[I][3*j-2] = distmat[j][i];
				outmat[I][3*j-1] = inf;
				outmat[I][3*j] = inf;
			}
		}
	I=3*size;
        printf("NAME : %s\n",argv[1]);
	printf("COMMENT : from symmetrize\n");
	printf("TYPE : TSP\nDIMENSION : %d\n",3*size);
	printf("EDGE_WEIGHT_TYPE : EXPLICIT\n");
	printf("EDGE_WEIGHT_FORMAT : UPPER_DIAG_ROW\n");
	printf("EDGE_WEIGHT_SECTION\n");
	for (i=1;i<=3*size;i++) {
		for (j=i;j<=I;j++) printf("%d\n",outmat[i][j]);
	}
}
