#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "genrand.h"
#define MAXN 3200
#define MAXCOORD 1000000
#define MAXMACHINES 101

int job[MAXN][MAXMACHINES];
int N,M;

int dist(int a, int b);

main(argc,argv)
int argc;
char *argv[];
{
	int maxcoord = MAXCOORD;
	
	int i,j;
	int seed;
	double prob = 1.000; /* needed for consistency with original */
	int useless; /* needed for consistency with original */
	int arg = 1;
	int tsplib = 0;

	if (argc < 5) {
		printf("Usage: shopgen [-tsplib] #cities seed #processors maxcoord > filename\n");
		exit(1);
		}
	if (strcmp(argv[arg], "-tsplib") == 0)  {
		tsplib = 1;
		++arg;
	}
	N = atoi(argv[arg++]);
	seed = atoi(argv[arg++]);
	M = atoi(argv[arg++]);
	maxcoord = atoi(argv[arg++]);

	/* initialize random number generator */

	sprand(seed);

	for (i=1;i<=N;i++) {
	    job[i][0] = 0;
	    for (j=1;j<=M;j++) {
		useless = rangerand(maxcoord);
		if (0 < prob) {
			job[i][j] = rangerand(maxcoord);
		}
		else job[i][j] = 0;
	    }
	}
/*
	for (i=1;i<=N;i++) {
	    for (j=1;j<=M;j++) printf("%d ",job[i][j]);
	    printf("\n");
	}
*/

	if (tsplib) {
		printf("NAME: shopgen_%d_%d_%d_%d\n", N, seed, M, maxcoord);
		printf("TYPE: ATSP\n");
		printf("COMMENT: Asymmetric TSP (generated with 'shopgen %d %d %d %d')\n",N, seed, M, maxcoord);
		printf("DIMENSION: %d\n", N);
		printf("EDGE_WEIGHT_TYPE: EXPLICIT\n");
		printf("EDGE_WEIGHT_FORMAT: FULL_MATRIX\n");
		printf("EDGE_WEIGHT_SECTION\n");
	}
	else {
		printf("%d A\n",N);
	}

	for (i=1;i<=N;i++)
	   for (j=1;j<=N;j++) printf("%d\n",dist(i,j));

	if (tsplib) {
		printf("EOF\n");
	}
	else {
		printf("shopgen %d %d %d %d\n",N,seed,M,maxcoord);
	};
}

dist (a,b)
int a,b;
{
  int max, temp, i;

  max = job[b][M];
  temp = max;
  for (i=M;i>0;i--) {
	temp = temp + job[b][i-1] - job[a][i];
	if (temp > max) max = temp;
  }
  return(max);
}
