#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "genrand.h"
#define MAXCOORD 1000000
#define MAXN 3200

int x[MAXN], y[MAXN];
int factor,down,up;

int dist(int a, int b);

main(argc,argv)
int argc;
char *argv[];
{
	int maxcoord = MAXCOORD;
	int N;
	int i,j;
	int seed;
	int arg = 1;
	int tsplib = 0;

	if (argc < 6) {
		printf("Usage: rtiltgen [-tsplib] N seed xfactor downfactor upfactor [maxcoord] > filename\n");
		exit(1);
		}
	if (strcmp(argv[arg], "-tsplib") == 0)  {
		tsplib = 1;
		++arg;
	}
	N = atoi(argv[arg++]);
	seed = atoi(argv[arg++]);
	factor = atoi(argv[arg++]);
	down = atoi(argv[arg++]);
	up = atoi(argv[arg++]);
	if (argc > arg) maxcoord = atoi(argv[arg++]);

	/* initialize random number generator */

	sprand(seed);

	for (i=1;i<=N;i++) {
	    x[i] = rangerand(maxcoord);
	    y[i] = rangerand(maxcoord);
	    }

	if (tsplib) {
		printf("NAME: rtiltgen_%d_%d_%d_%d_%d_%d\n", N, seed, factor, down, up, maxcoord);
		printf("TYPE: ATSP\n");
		printf("COMMENT: Asymmetric TSP (generated with 'rtiltgen %d %d %d %d %d %d')\n",N, seed, factor, down, up, maxcoord);
		printf("DIMENSION: %d\n", N);
		printf("EDGE_WEIGHT_TYPE: EXPLICIT\n");
		printf("EDGE_WEIGHT_FORMAT: FULL_MATRIX\n");
		printf("EDGE_WEIGHT_SECTION\n");
	}
	else {
		printf("%d A\n",N);
	}

	for (i=1;i<=N;i++)
	    for (j=1;j<=N;j++) printf("%d\n",dist(i,j));

	if (tsplib) {
		printf("EOF\n");
	}
	else {
		printf("rtiltgen %d %d %d %d %d %d\n",N,seed,factor,down,up,maxcoord);
	};
}

dist (a,b)
int a,b;
{
    int t, sum;
#ifdef BUG2
    printf("dist(%d,%d)\n",a,b);
#endif

    if (a == b) return (1<<29);
    t = x[a]-x[b];
    if (t < 0) t = -t;
    sum = t*factor;

    t = y[b]-y[a];
    if (t >= 0) sum += t*up;
    else sum -= t*down;

    return(sum);
}

