/*
Generates disk drive instances: toroidal stacker crane with modified
sup norm
*/
#include <stdio.h>
#include <sys/types.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "genrand.h"
#define MAXN 3200
#define MAXCOORD 1000000
#define FACTOR 1

main(argc,argv)
int argc;
char *argv[];
{
	int maxcoord = MAXCOORD;
	int factor;    /* ratio of track length to max file size */
	double speed;  /* ratio of horizontal to vertical speed */
	int N;
	int i,j,k,d;
	int x[MAXN], y[MAXN], z[MAXN];
	int w, u, du;
	int seed;
	int arg = 1;
	int tsplib = 0;

	if (argc < 5) {
	   printf("Usage: diskgen [-tsplib] N seed factor speed [maxcoord] > filename\n");
	   exit(1);
	}
	if (strcmp(argv[arg], "-tsplib") == 0)  {
		tsplib = 1;
		++arg;
	}
	N = atoi(argv[arg++]);
	seed = atoi(argv[arg++]);
	factor = atoi(argv[arg++]);
	speed = atof(argv[arg++]);
	if (argc > 5) maxcoord = atoi(argv[arg++]);

	/* initialize random number generator */

	sprand(seed);

	for (i=1;i<=N;i++) {
	    x[i] = rangerand(maxcoord);
	    y[i] = rangerand(maxcoord);
	    w = rangerand(maxcoord);
	    w = w/factor + x[i];
	    if (w>maxcoord) w -= maxcoord;
	    z[i] = w;
/*
	    printf("%d	%d  %d\n",x[i],y[i],z[i]);
*/
	}

	if (tsplib) {
		printf("NAME: diskgen_%d_%d_%d_%.4f_%d\n", N, seed, factor, speed, maxcoord);
		printf("TYPE: ATSP\n");
		printf("COMMENT: Asymmetric TSP (generated with 'diskgen %d %d %d %.4f %d')\n",N, seed, factor, speed, maxcoord);
		printf("DIMENSION: %d\n", N);
		printf("EDGE_WEIGHT_TYPE: EXPLICIT\n");
		printf("EDGE_WEIGHT_FORMAT: FULL_MATRIX\n");
		printf("EDGE_WEIGHT_SECTION\n");
	}
	else {
		printf("%d A\n",N);
	}

	for (i=1;i<=N;i++)
	   for (j=1;j<=N;j++) {
		w = x[j] - z[i];
		u = speed*(y[i]-y[j]);
		if (u<0) u = -u;
		du = u;
		k = 0;
		while (du > maxcoord) {
		   du -= maxcoord;
		   k += maxcoord;
		}
		if (du <= w) d = k + w;
		else if (w - du >= -maxcoord) d = w - du + maxcoord + k;
		else d =  w - du +2*maxcoord +k;
/*		printf("%6d : u= %6d, w= %6d du= %6d k= %6d\n",d,u,w,du,k); */
		printf("%d\n",d);	
	   }

	if (tsplib) {
		printf("EOF\n");
	}
	else {
		printf("diskgen %d %d %d %.4f %d\n",N,seed,factor,speed,maxcoord);
	};
}
