#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "genrand.h"
#define MAXCOORD 1000000

int main(int argc, char *argv[])
{
	int maxcoord = MAXCOORD;
	int N;
	int i,j;
	int x;
	int seed;
	int arg = 1;
	int tsplib = 0;

	if (argc < 3) {
		printf("Usage: amatgen [-tsplib] #cities seed [maxcoord] > filename\n");
		exit(1);
		}
	if (strcmp(argv[arg], "-tsplib") == 0)  {
		tsplib = 1;
		++arg;
	}
	N = atoi(argv[arg++]);
	seed = atoi(argv[arg++]);
	if (argc > arg) maxcoord = atoi(argv[arg++]);

	/* initialize random number generator */

	sprand(seed);

	if (tsplib) {
		printf("NAME: amatgen_%d_%d_%d\n", N, seed, maxcoord);
		printf("TYPE: ATSP\n");
		printf("COMMENT: Asymmetric TSP (generated with 'amatgen %d %d %d')\n",N, seed, maxcoord);
		printf("DIMENSION: %d\n", N);
		printf("EDGE_WEIGHT_TYPE: EXPLICIT\n");
		printf("EDGE_WEIGHT_FORMAT: FULL_MATRIX\n");
		printf("EDGE_WEIGHT_SECTION\n");
	}
	else {
		printf("%d A\n",N);
	}

	for (i=1;i<=N;i++)
	    for (j=1;j<=N;j++) {
                x = rangerand (maxcoord);
		printf("%d\n",x);
	    }

	if (tsplib) {
		printf("EOF\n");
	}
	else {
		printf("amatgen %d %d %d\n",N,seed,maxcoord);
	};

	return 0;
}
